<?php
// schedule_runner.php
date_default_timezone_set("Asia/Kolkata");

$botToken = "8071604612:AAGU8vtwZXh75XqBdxCSBdFWJ_x5CCy3e14";
$usersFile = __DIR__ . "/users.txt";
$schedulesFile = __DIR__ . "/schedules.json";
$lastSentFile = __DIR__ . "/last_sent.json";
$apiLog = __DIR__ . "/api_log.txt";
$cronLog = __DIR__ . "/cron_log.txt";

// ensure files exist
if (!file_exists($usersFile)) file_put_contents($usersFile, "");
if (!file_exists($schedulesFile)) file_put_contents($schedulesFile, json_encode([]));
if (!file_exists($lastSentFile)) file_put_contents($lastSentFile, json_encode([]));

$users = file($usersFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$schedules = json_decode(file_get_contents($schedulesFile), true) ?: [];
$lastSent = json_decode(file_get_contents($lastSentFile), true) ?: [];

$now = date("H:i"); // current minute

foreach ($schedules as $sched) {
    // expected schedule object: ['id'=>int,'time'=>'HH:MM','text'=>'','image'=>'uploads/..','active'=>true]
    if (empty($sched['active'])) continue;
    if (($sched['time'] ?? '') !== $now) continue;

    $sid = $sched['id'];
    // Avoid duplicate sending in same minute
    if (isset($lastSent[$sid]) && $lastSent[$sid] === $now) {
        continue;
    }

    // prepare send
    $messageText = $sched['text'] ?? '';
    $image = $sched['image'] ?? '';

    foreach ($users as $chat_id) {
        if (!empty($image) && file_exists(__DIR__ . "/" . $image)) {
            // send photo with caption via multipart curl
            $url = "https://api.telegram.org/bot$botToken/sendPhoto";
            $post = [
                'chat_id' => $chat_id,
                'caption' => $messageText,
                'parse_mode' => 'HTML',
                'photo' => new CURLFile(__DIR__ . "/" . $image)
            ];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_SAFE_UPLOAD, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
            $response = curl_exec($ch);
            $err = curl_error($ch);
            curl_close($ch);
        } else {
            // text only
            $url = "https://api.telegram.org/bot$botToken/sendMessage";
            $post = http_build_query([
                'chat_id' => $chat_id,
                'text' => $messageText,
                'parse_mode' => 'HTML'
            ]);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
            $response = curl_exec($ch);
            $err = curl_error($ch);
            curl_close($ch);
        }

        file_put_contents($apiLog, date("Y-m-d H:i:s") . " -> chat:$chat_id sched:$sid err:$err resp:" . substr($response ?? '',0,500) . PHP_EOL, FILE_APPEND);
    }

    // mark last sent for this schedule id as this minute
    $lastSent[$sid] = $now;
    file_put_contents($lastSentFile, json_encode($lastSent));
    file_put_contents($cronLog, date("Y-m-d H:i:s") . " Sent schedule id:$sid time:$now\n", FILE_APPEND);
}
?>
