<?php
session_start();
if (empty($_SESSION['admin'])) { header("Location: login.php"); exit; }

$base = dirname(__DIR__);
$schedulesFile = $base . "/schedules.json";
$schedules = json_decode(file_get_contents($schedulesFile), true) ?: [];

$statusFile = $base . "/auto_status.txt";
$autoStatus = trim(file_exists($statusFile) ? file_get_contents($statusFile) : "on");

if (isset($_GET['toggle'])) {
    $newStatus = ($autoStatus === "on") ? "off" : "on";
    file_put_contents($statusFile, $newStatus);
    header("Location: index.php");
    exit;
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Scheduler Admin</title>
<style>
body {
  background-color: #000;
  color: #ffd700;
  font-family: Arial, sans-serif;
  text-align: center;
}
table {
  border-collapse: collapse;
  margin: 20px auto;
  width: 90%;
  color: #000;
  background: #fff8dc;
}
th, td {
  padding: 8px 12px;
  border: 1px solid #444;
}
a {
  color: #000;
  text-decoration: none;
  font-weight: bold;
}
.toggle-btn {
  display: inline-block;
  padding: 10px 18px;
  border-radius: 10px;
  color: #000;
  background-color: #ffd700;
  text-decoration: none;
  font-weight: bold;
  margin: 10px;
}
.toggle-btn:hover {
  background-color: #ffb700;
}
.status-text {
  font-size: 18px;
  margin-bottom: 10px;
}
</style>
</head>
<body>

<h2>🐔 Scheduler Admin Panel</h2>

<!-- Auto Message Toggle Section -->
<div class="status-text">
Auto Message Status:
<b style="color:<?=($autoStatus==='on'?'#00ff00':'#ff4444')?>;">
<?= strtoupper($autoStatus) ?>
</b>
</div>

<a href="?toggle=1" class="toggle-btn">
<?=($autoStatus==='on'?'🛑 Stop Auto Messages':'▶️ Start Auto Messages')?>
</a>

<hr style="border:1px solid #ffd700; width:80%;">

<p><a href="add_edit.php">➕ Add New Schedule</a> | 
<a href="logout.php">🚪 Logout</a></p>

<table>
<tr>
  <th>ID</th><th>Time</th><th>Text</th><th>Image</th><th>Active</th><th>Actions</th>
</tr>
<?php foreach($schedules as $s): ?>
<tr>
  <td><?=htmlspecialchars($s['id'])?></td>
  <td><?=htmlspecialchars($s['time'])?></td>
  <td><?=nl2br(htmlspecialchars($s['text']))?></td>
  <td><?=!empty($s['image'])?'<img src="../uploads/'.htmlspecialchars(basename($s['image'])).'" width="80">':'—'?></td>
  <td><?=!empty($s['active'])?'Yes':'No'?></td>
  <td>
    <a href="add_edit.php?id=<?=$s['id']?>">✏️ Edit</a> |
    <a href="delete.php?id=<?=$s['id']?>" onclick="return confirm('Delete this schedule?')">🗑 Delete</a>
  </td>
</tr>
<?php endforeach; ?>
</table>

<h3>🧾 Manual Actions</h3>
<ul style="list-style:none; line-height:1.8;">
<li>📁 Uploaded images folder: <code>/uploads/</code></li>
<li><a href="../api_log.txt" target="_blank">View API Log</a> | <a href="../cron_log.txt" target="_blank">View Cron Log</a></li>
</ul>

</body>
</html>
