<?php
// ✅ Final Telegram Auto Broadcaster (1-minute messages)
date_default_timezone_set("Asia/Kolkata");

$botToken = "8071604612:AAGU8vtwZXh75XqBdxCSBdFWJ_x5CCy3e14"; // 👈 apna token daalo
$usersFile = __DIR__ . "/users.txt";
$messagesFile = __DIR__ . "/messages.txt";
$logFile = __DIR__ . "/api_log.txt";

// Ensure log files exist
if (!file_exists($usersFile)) file_put_contents($usersFile, "");
if (!file_exists($messagesFile)) {
    $demo = [
        "🍿 Movie of the day: Check it out now!",
        "🎬 Don’t miss today’s new release!",
        "🔥 Top trending movies for you!",
        "📽️ Fresh update every minute!"
    ];
    file_put_contents($messagesFile, implode("\n", $demo));
}

// Read users & messages
$users = file($usersFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$messages = file($messagesFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if (!empty($users) && !empty($messages)) {
    $message = $messages[array_rand($messages)];

    foreach ($users as $chat_id) {
        $url = "https://api.telegram.org/bot$botToken/sendMessage?chat_id=$chat_id&text=" . urlencode($message);

        // Use CURL for reliability
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $curlError = curl_error($ch);
        curl_close($ch);

        // Log responses
        file_put_contents($logFile, date("H:i:s") . " -> ChatID: $chat_id | CURL: $curlError | Response: $response\n", FILE_APPEND);
    }

    file_put_contents(__DIR__ . "/cron_log.txt", date("H:i:s") . " ✅ Sent message: $message\n", FILE_APPEND);
} else {
    file_put_contents(__DIR__ . "/cron_log.txt", date("H:i:s") . " ⚠️ No users or messages found.\n", FILE_APPEND);
}
?>
