<?php
date_default_timezone_set("Asia/Kolkata");

// Telegram bot setup
$botToken = "8071604612:AAGU8vtwZXh75XqBdxCSBdFWJ_x5CCy3e14";
$apiUrl = "https://api.telegram.org/bot$botToken/sendMessage";
$apiPhoto = "https://api.telegram.org/bot$botToken/sendPhoto";
$usersFile = __DIR__ . "/users.txt";

// Database connection
$con = mysqli_connect("localhost", "jrszratg_chiknroadd", "jrszratg_chiknroadd", "jrszratg_chiknroadd");
if (!$con) {
    file_put_contents("api_log.txt", date("H:i:s") . " ❌ DB connection failed\n", FILE_APPEND);
    exit;
}

// -------- STEP 1: Scheduled Messages --------
$now = date("Y-m-d H:i:s");
$q = mysqli_query($con, "SELECT * FROM scheduled_posts WHERE status='pending' AND send_time <= '$now'");
if ($q && mysqli_num_rows($q) > 0) {
    while ($post = mysqli_fetch_assoc($q)) {
        $msg = $post['message'];
        $img = trim($post['image']);
        $users = file($usersFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($users as $chat_id) {
            if ($img != '') {
                $data = ['chat_id' => $chat_id, 'caption' => $msg, 'photo' => $img];
                $url = $apiPhoto;
            } else {
                $data = ['chat_id' => $chat_id, 'text' => $msg];
                $url = $apiUrl;
            }
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $data
            ]);
            curl_exec($ch);
            curl_close($ch);
        }
        mysqli_query($con, "UPDATE scheduled_posts SET status='sent' WHERE id='{$post['id']}'");
        file_put_contents("api_log.txt", date("H:i:s") . " ✅ Scheduled post sent: {$post['id']}\n", FILE_APPEND);
    }
}

// -------- STEP 1.5: Auto system check --------
$statusFile = __DIR__ . "/auto_status.txt";
$autoStatus = trim(file_exists($statusFile) ? file_get_contents($statusFile) : "on");
if ($autoStatus !== "on") {
    file_put_contents("cron_log.txt", date("H:i:s") . " ⚙️ Auto system OFF — skipping random messages\n", FILE_APPEND);
    exit;
}

// -------- STEP 2: Random Prediction --------
$multipliers = [
    1 => ['easy'=>1.03, 'medium'=>1.12, 'hard'=>1.23],
    2 => ['easy'=>1.07, 'medium'=>1.28, 'hard'=>1.55],
    3 => ['easy'=>1.12, 'medium'=>1.47, 'hard'=>1.98],
    4 => ['easy'=>1.17, 'medium'=>1.7,  'hard'=>2.56],
    5 => ['easy'=>1.23, 'medium'=>1.98, 'hard'=>3.36],
    6 => ['easy'=>1.29, 'medium'=>2.33, 'hard'=>4.49],
    7 => ['easy'=>1.36, 'medium'=>2.76, 'hard'=>5.49],
    8 => ['easy'=>1.44, 'medium'=>3.32, 'hard'=>7.53],
    9 => ['easy'=>1.53, 'medium'=>4.03, 'hard'=>10.56],
    10 => ['easy'=>1.63, 'medium'=>4.96, 'hard'=>15.21],
    11 => ['easy'=>1.75, 'medium'=>5.75, 'hard'=>18.23],
    12 => ['easy'=>1.88, 'medium'=>6.2,  'hard'=>22.59],
    13 => ['easy'=>2.04, 'medium'=>6.91, 'hard'=>34.79],
    14 => ['easy'=>2.22, 'medium'=>7.22, 'hard'=>55.97],
    15 => ['easy'=>2.45, 'medium'=>8.45, 'hard'=>94.99],
    16 => ['easy'=>2.72, 'medium'=>8.9,  'hard'=>95.45],
    17 => ['easy'=>3.06, 'medium'=>10.06,'hard'=>97.72],
    18 => ['easy'=>3.5,  'medium'=>11.5, 'hard'=>103.06],
    19 => ['easy'=>4.08, 'medium'=>13.08,'hard'=>112.5]
];

$res = mysqli_query($con, "SELECT easy, medium, hard FROM gameOver LIMIT 1");
$row = mysqli_fetch_assoc($res);
$easyVal = (int)$row['easy'];
$medVal  = (int)$row['medium'];
$hardVal = (int)$row['hard'];

$modes = ['easy','medium','hard'];
$chosen = $modes[array_rand($modes)];
$currentVal = ($chosen == 'hard') ? rand(1, 8) : rand(1, 19);
$multi = $multipliers[$currentVal][$chosen];

// 🟡 Updated Stylish Message
$modeText = strtoupper($chosen); // EASY / MEDIUM / HARD

$msg  = "🔥 *BET NOW* 🔥\n\n";
$msg .= "🎮 Mode: *{$modeText}*\n";
$msg .= "🏆 Cash Out → *{$multi}x* 💰\n\n";
$msg .= "👉 *Play only on https://chicknroads.club/signup?code=4142861*";

$users = file($usersFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
foreach ($users as $chat_id) {
    $data = ['chat_id' => $chat_id, 'text' => $msg, 'parse_mode' => 'Markdown'];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $data
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// ✅ FIXED PART BELOW
// Save next number based on which multiplier message was generated
$newVal = $currentVal + 1;
if ($chosen == 'hard' && $newVal > 8) $newVal = 1; // hard mode max = 8
if ($chosen != 'hard' && $newVal > 19) $newVal = 1;
mysqli_query($con, "UPDATE gameOver SET $chosen = '$newVal'");

file_put_contents("cron_log.txt", date("H:i:s") . " ✅ Random $chosen={$multi}x (Saved: $newVal)\n", FILE_APPEND);

// -------- STEP 3: Send Result Image After 1 Minute --------
sleep(60); // wait 1 minute
$imagePath = __DIR__ . "/{$chosen}_images/" . $multi . "x.png";
$imageUrl = "https://gamefun.chicknroads.club/{$chosen}_images/" . $multi . "x.png";

if (file_exists($imagePath)) {
    foreach ($users as $chat_id) {
        $caption = "🎯 Result: *{$multi}x* ({$chosen})";
        $data = [
            'chat_id' => $chat_id,
            'photo' => $imageUrl,
            'caption' => $caption,
            'parse_mode' => 'Markdown'
        ];
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $apiPhoto,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data
        ]);
        curl_exec($ch);
        curl_close($ch);
    }
    file_put_contents("cron_log.txt", date("H:i:s") . " 🖼 Result image sent: {$imageUrl}\n", FILE_APPEND);
} else {
    file_put_contents("cron_log.txt", date("H:i:s") . " ⚠️ Image not found: {$imagePath}\n", FILE_APPEND);
}

// Reset values after 30 sec
sleep(30);
mysqli_query($con, "UPDATE gameOver SET easy='R7', medium='R6', hard='R5'");
mysqli_close($con);
?>
