<?php
session_start();
if (empty($_SESSION['admin'])) { header("Location: login.php"); exit; }

$base = dirname(__DIR__);
$schedulesFile = $base . "/schedules.json";
$schedules = json_decode(file_get_contents($schedulesFile), true) ?: [];

?>
<!doctype html><html><head><meta charset="utf-8"><title>Scheduler Admin</title></head><body>
<h2>Scheduler Admin</h2>
<p><a href="add_edit.php">Add New Schedule</a> | <a href="logout.php">Logout</a></p>

<table border="1" cellpadding="6">
<tr><th>ID</th><th>Time</th><th>Text</th><th>Image</th><th>Active</th><th>Actions</th></tr>
<?php foreach($schedules as $s): ?>
<tr>
  <td><?=htmlspecialchars($s['id'])?></td>
  <td><?=htmlspecialchars($s['time'])?></td>
  <td><?=nl2br(htmlspecialchars($s['text']))?></td>
  <td><?=!empty($s['image'])?htmlspecialchars($s['image']):'—'?></td>
  <td><?=!empty($s['active'])?'Yes':'No'?></td>
  <td>
    <a href="add_edit.php?id=<?=$s['id']?>">Edit</a> |
    <a href="delete.php?id=<?=$s['id']?>" onclick="return confirm('Delete?')">Delete</a>
  </td>
</tr>
<?php endforeach; ?>
</table>

<h3>Manual Actions</h3>
<ul>
<li>Uploaded images folder: <code>/uploads/</code></li>
<li><a href="../api_log.txt" target="_blank">View API Log</a> | <a href="../cron_log.txt" target="_blank">View Cron Log</a></li>
</ul>
</body></html>
