<?php
session_start();
if (empty($_SESSION['admin'])) { header("Location: login.php"); exit; }

$base = dirname(__DIR__);
$schedulesFile = $base . "/schedules.json";
$uploadsDir = $base . "/uploads/";
$schedules = json_decode(file_get_contents($schedulesFile), true) ?: [];

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$editing = $id > 0;
$rec = ['id'=>0,'time'=>'12:00','text'=>'','image'=>'','active'=>1];
if ($editing) {
    foreach($schedules as $s) if($s['id']==$id) $rec = $s;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $time = $_POST['time'];
    $text = $_POST['text'];
    $image = $_POST['image'];
    $active = isset($_POST['active']) ? 1 : 0;

    if ($editing) {
        foreach($schedules as &$s) {
            if ($s['id'] == $id) {
                $s['time'] = $time;
                $s['text'] = $text;
                $s['image'] = $image;
                $s['active'] = $active;
            }
        }
    } else {
        $newId = count($schedules) ? max(array_column($schedules,'id')) + 1 : 1;
        $schedules[] = ['id'=>$newId,'time'=>$time,'text'=>$text,'image'=>$image,'active'=>$active];
    }

    file_put_contents($schedulesFile, json_encode($schedules, JSON_PRETTY_PRINT));
    header("Location: dashboard.php"); exit;
}

$images = [];
if (is_dir($uploadsDir)) {
    foreach (scandir($uploadsDir) as $f) {
        if (preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $f)) {
            $images[] = "uploads/" . $f;
        }
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title><?= $editing ? 'Edit' : 'Add' ?> Schedule</title>
<style>
body { font-family: Arial; margin: 30px; }
.image-list { max-height:200px; overflow:auto; border:1px solid #ccc; padding:5px; display:none; }
.image-list img { width:80px; height:80px; object-fit:cover; margin:5px; border:2px solid transparent; cursor:pointer; }
.image-list img:hover { border-color:#007BFF; }
</style>
</head>
<body>
<h2><?= $editing ? 'Edit' : 'Add' ?> Schedule</h2>

<form method="post" id="scheduleForm">
    <label>Time (HH:MM 24hr):</label>
    <input type="time" name="time" value="<?=htmlspecialchars($rec['time'])?>" required><br><br>

    <label>Message Text:</label><br>
    <textarea name="text" rows="4" cols="60"><?=htmlspecialchars($rec['text'])?></textarea><br><br>

    <label>Image:</label><br>
    <input type="text" name="image" id="imagePath" value="<?=htmlspecialchars($rec['image'])?>" placeholder="uploads/your.jpg" style="width:300px;">
    <button type="button" id="btnSelect">Select Image</button>
    <button type="button" id="btnUpload">Upload Image</button>

    <div class="image-list" id="imageList">
        <?php foreach ($images as $img): ?>
            <img src="../<?=htmlspecialchars($img)?>" data-path="<?=htmlspecialchars($img)?>">
        <?php endforeach; ?>
    </div>

    <label><input type="checkbox" name="active" <?=!empty($rec['active'])?'checked':''?>> Active</label><br><br>
    <button type="submit">💾 Save Schedule</button>
</form>

<!-- ✅ Upload form moved OUTSIDE main form -->
<div id="uploadBox" style="display:none; margin-top:20px;">
    <h3>Upload New Image</h3>
    <form id="uploadForm" enctype="multipart/form-data">
        <input type="file" name="image" accept="image/*" required>
        <button type="submit">Upload</button>
    </form>
    <div id="uploadResult"></div>
</div>

<p><a href="dashboard.php">⬅ Back</a></p>

<script>
const imgList = document.getElementById('imageList');
const btnSelect = document.getElementById('btnSelect');
const btnUpload = document.getElementById('btnUpload');
const imgPath = document.getElementById('imagePath');
const uploadBox = document.getElementById('uploadBox');
const uploadForm = document.getElementById('uploadForm');
const uploadResult = document.getElementById('uploadResult');

btnSelect.onclick = () => {
    uploadBox.style.display = "none";
    imgList.style.display = imgList.style.display === "block" ? "none" : "block";
};

btnUpload.onclick = () => {
    imgList.style.display = "none";
    uploadBox.style.display = uploadBox.style.display === "block" ? "none" : "block";
};

imgList.querySelectorAll('img').forEach(img => {
    img.onclick = () => {
        imgPath.value = img.dataset.path;
        imgList.style.display = "none";
    };
});

uploadForm.onsubmit = e => {
    e.preventDefault();
    const formData = new FormData(uploadForm);
    fetch('upload_image.php', { method: 'POST', body: formData })
        .then(res => res.text())
        .then(txt => {
            if (txt.includes("uploads/")) {
                const match = txt.match(/uploads\/[^\s<]+/);
                if (match) {
                    imgPath.value = match[0];
                    uploadResult.innerHTML = "<span style='color:green'>Uploaded & selected: " + match[0] + "</span>";
                }
            } else {
                uploadResult.innerHTML = "<span style='color:red'>Upload failed</span>";
            }
        })
        .catch(err => uploadResult.innerHTML = "Error: " + err);
};
</script>
</body>
</html>
